/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.formatting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.editor.php.internal.ui.editor.formatting.AbstractPHPAutoEditStrategy;
import com.aptana.parsing.lexer.Lexeme;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;

public class PhpDocAutoIndentStrategy
extends AbstractPHPAutoEditStrategy {
    private static final String PHP_MULTILINE_COMMENT_MID = " * ";
    private static final String PHP_MULTILINE_COMMENT_END = " */";

    public PhpDocAutoIndentStrategy(String contentType, PHPSourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(contentType, configuration, sourceViewer);
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.innerCustomizeDocumentCommand(document, command);
        this.lexemeProvider = null;
    }

    private void innerCustomizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text != null && command.length == 0 && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
            int offset = command.offset;
            try {
                ITypedRegion region = document.getPartition(offset);
                if (region != null) {
                    this.getLexemeProvider(document, offset, false);
                    Lexeme lexeme = this.lexemeProvider.getFloorLexeme(offset);
                    String lexemeType = ((PHPTokenType)lexeme.getType()).getType();
                    if (document.getLength() == offset && (lexemeType.equals("PHPDOC_COMMENT_END") || lexemeType.equals("PHP_COMMENT_END")) && document.get(offset - 2, 2).equals("*/")) {
                        Lexeme commentStartLexeme = this.lexemeProvider.getFirstLexeme();
                        String indent = this.getIndentationAtOffset(document, commentStartLexeme.getStartingOffset());
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + indent.length();
                        command.text = String.valueOf(command.text) + indent;
                        return;
                    }
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error customizing the auto-indent for a PHP documentation block", (Throwable)e);
            }
            this.indentDocAfterNewLine(document, command);
        }
    }

    private void indentDocAfterNewLine(IDocument document, DocumentCommand command) {
        Lexeme lastLexeme = this.lexemeProvider.getLastLexeme();
        Lexeme firstLexeme = this.lexemeProvider.getFirstLexeme();
        String indent = this.getIndentationAtOffset(document, firstLexeme.getStartingOffset());
        String lexemeType = ((PHPTokenType)lastLexeme.getType()).getType();
        StringBuilder builder = new StringBuilder(command.text);
        builder.append(indent);
        if (command.offset > firstLexeme.getEndingOffset() && ("PHPDOC_COMMENT_END".equals(lexemeType) || "PHP_COMMENT_END".equals(lexemeType))) {
            builder.append(PHP_MULTILINE_COMMENT_MID);
        } else {
            command.shiftsCaret = false;
            command.caretOffset = command.offset + command.text.length() + indent.length() + PHP_MULTILINE_COMMENT_MID.length();
            builder.append(PHP_MULTILINE_COMMENT_MID);
            builder.append(command.text);
            builder.append(indent);
            builder.append(PHP_MULTILINE_COMMENT_END);
        }
        command.text = builder.toString();
    }
}

